qui {

 noisily {
/**********************************************************************************************/
/**********************************************************************************************/
/*********************** Step 3. Semi-parametric route: Second-step ****************************/
/**********************************************************************************************/
/**********************************************************************************************/

/*
*/

	/*************************************************/
	/************* Step 3.1. Data collection *******/
	/*************************************************/
}

	* Get necessary data
		
		* Independence dividend estimates
		cd ..
		cd "./3. Intermediary results"
		use IDD1_ci, clear
		drop PTDIDD_ll PTDIDD_ul
		cd ..
	
		* Potential determinants
		cd "./4. Master data"
		merge 1:1 cntrycode year independence_years using master_data, keepusing(region surface mother_country_name pop baseline_lgdpcap market_potential educ health open dem bdeaths crisis soviet_dummy yugoslav_dummy referendum_dummy EU_dummy NATO_dummy AU_dummy ASEAN_dummy doil popshare)
		keep if _merge == 3
		drop _merge
		cd ..
		
		* Mother countries
		cd "./4. Master data"
		drop mother_country_name
		merge 1:1 cntry independence_years year using master_data, keepusing(mother_country_name)
		keep if _merge == 3
		drop _merge
		cd ..
		
		* RMSPE
		cd "./3. Intermediary results"
		merge m:m cntrycode using IDD1, keepusing(rmspe)
		keep if _merge == 3
		drop _merge
		cd ..
		sort cntrycode year

		* Violent secessions
		
			* Get correct couyntry codes for merge
			cd ".\3. Intermediary results"
			preserve
			use setup, clear
			merge 1:m cntrycode_BG using Griffiths
			drop if _merge == 2
			keep cntry year outcome
			keep if outcome == 7 /* non-violent secession */ | outcome == 8 /* violent secession */
			replace outcome = 0 if outcome == 7
			replace outcome = 1 if outcome == 8
			drop if year < $startyear
			sort cntry year
			collapse (mean) outcome, by(cntry)
			rename outcome violent_secession
			save violent_secessions, replace
			restore
			
			* Add data
			merge m:1 cntry using violent_secessions
			drop if _merge == 2
			drop _merge
			
			* Manually fill in missings
			gen missing = 1 if violent_secession == .
			replace violent_secession = 0 if cntry == "Czech Republic" | cntry == "Libya" | cntry == "Nauru" | cntry == "Palau" | cntry == "St. Kitts and Nevis"
			replace violent_secession = 1 if cntry == "North Korea" | cntry == "South Korea" | cntry == "Russia" | cntry == "ZzSerbia"
			
			noi di "Manually filled in missings:"
			sort violent_secession cntry
			noi list cntry violent_secession if independence_years == 0 & missing == 1
			drop missing
			
		* Generate initial per capita GDP, express all GDP-related data in logs
		gen initial_gdpcap = .
		levelsof cntrycode if independence_years == 0, local(NICs)
		foreach cntry in `NICs' {
			sum baseline_lgdpcap if cntrycode == `cntry' & independence_years == 0
			replace initial_gdpcap = r(mean) if cntrycode == `cntry'
			}
		drop pop
		replace market_potential = ln(market_potential)

		* Generate a dummy variable indicating transition countries
		egen regioncode = group(region)
		gen transition = 1 if mother_country_name == "Russia" & cntry != "German Democratic Republic" & cntry != "North Korea" | mother_country_name == "Yugoslavia" | mother_country_name == "Czechoslovakia"
		replace transition = 0 if transition == .
		
		* Generate a dummy variable indicating landlocked countries
		// Source: http://worldpopulationreview.com/countries/landlocked-countries/
		gen landlocked = 1 if cntry == "Afghanistan" | cntry == "Andorra" | cntry == "Armenia" | cntry == "Azerbaijan" | cntry == "Belarus" | cntry == "Bhutan" | cntry == "Bolivia" ///
							| cntry == "Burkina Faso" | cntry == "Burundi" | cntry == "Central African Republic" | cntry == "Chad" | cntry == "Czech Republic" | cntry == "Ethiopia" ///
							| cntry == "Hungary" | cntry == "Kazakhstan" | cntry == "Kosovo" | cntry == "Kyrgyzstan" | cntry == "Laos" | cntry == "Basutoland (Lesotho)" 			///
							| cntry == "Liechtenstein" | cntry == "Luxembourg" | cntry == "Macedonia" | cntry == "Malawi" | cntry == "Mali" | cntry == "Moldova"					///
							| cntry == "Mongolia" | cntry == "Nepal" | cntry == "Niger" | cntry == "Paraguay" | cntry == "Ruanda" | cntry == "San Marino" | cntry == "ZzSerbia"		///	
							| cntry == "South Sudan" | cntry == "Swaziland" | cntry == "Switzerland" | cntry == "Tajikistan" | cntry == "Turkmenistan" | cntry == "Uganda" 			///
							| cntry == "Uzbekistan" | cntry == "Zambia" | cntry == "Zimbabwe"
		replace landlocked = 0 if landlocked == .
		
		noi di "Landlocked countries:"
		sort cntry
		noi list cntry if independence_years == 0 & landlocked == 1

		* Save necessary data
		sort cntry year independence_years 
		cd ..
		cd "./4. Master data"
		save master_data_secondstep, replace
		cd ..
		
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
